---
title: "Installation de Docker"
course: "docker"
slug: "3-installation-de-docker"
order: 3
createdAt: 2025-09-24
updatedAt: 2025-09-24
---

Docker peut être installé sur Linux, macOS et Windows. Voici les instructions pour chaque système d'exploitation.

---

## Installation sur Linux

### Sur Ubuntu / Debian

```bash
sudo apt update
sudo apt install apt-transport-https ca-certificates curl software-properties-common

curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo gpg --dearmor -o /usr/share/keyrings/docker-archive-keyring.gpg

echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/docker-archive-keyring.gpg] https://download.docker.com/linux/ubuntu $(lsb_release -cs) stable" \
  | sudo tee /etc/apt/sources.list.d/docker.list > /dev/null

sudo apt update
sudo apt install docker-ce docker-ce-cli containerd.io
```

### Utiliser Docker sans sudo

Ensuite, pour utiliser Docker sans sudo :

```bash
sudo usermod -aG docker $USER
```

Redémarrer la session ou exécuter `newgrp docker`.

---

## Installation sur macOS

1. **Télécharger Docker Desktop** depuis le site officiel : https://www.docker.com/products/docker-desktop/
    
2. **Installer l'application** et la lancer.
    
3. **Vérifier** que Docker fonctionne avec :
    
    ```bash
    docker version
    ```
    

> [!warning] Prérequis
> Docker Desktop nécessite **macOS Ventura 13.3+** et un CPU Intel ou Apple Silicon.

---

## Installation sur Windows

1. **Télécharger Docker Desktop for Windows** : https://www.docker.com/products/docker-desktop/
    
2. **Prérequis :**
    
    - Windows 10/11 Pro ou Enterprise (Hyper-V activé)
    - Pour Home Edition : **WSL2** (Windows Subsystem for Linux) est requis
3. **Suivre l'installeur** et redémarrer si besoin
    
4. **Vérifier l'installation** avec :
    
    ```bash
    docker version
    ```
    

> [!info] Note importante
> Docker Desktop utilise WSL2 pour exécuter des conteneurs Linux sur Windows.

---

## Vérification post-installation

### Test simple

Lancer un conteneur de test :

```bash
docker run hello-world
```

**Cette commande :**

- Télécharge une image de test
- Lance un conteneur qui affiche un message de succès

Si vous voyez **"Hello from Docker!"**, l'installation est réussie.

### Vérification des informations système

```bash
docker info
```

Cette commande affiche des informations détaillées sur votre installation Docker.

---

## Alternative : Installation avec script de convenience

Pour Linux uniquement, Docker propose un script d'installation automatique :

```bash
curl -fsSL https://get.docker.com -o get-docker.sh
sudo sh get-docker.sh
```

> [!warning] Script de convenience
> Ce script est pratique pour le développement mais **non recommandé en production**.

---

## Différences Docker Desktop vs Docker Engine

|Aspect|Docker Desktop|Docker Engine|
|---|---|---|
|**Interface**|Interface graphique|Ligne de commande uniquement|
|**Systèmes**|Windows, macOS, Linux|Linux uniquement|
|**Utilisation**|Développement local|Serveurs, production|
|**Licence**|Gratuit pour usage personnel|Open source|

---

## Liens vers la partie suivante

- [[4. Commandes Docker essentielles]]

---

## Tags

#docker #installation #docker-desktop #linux #windows #macos #setup